#from Ronnie
#!/bin/bash
#accept a run folder, a sample sheet and a output folder; then do demultiplex for the run folder and input the raw data to the ouput folder
#change these 3 things (and also the bases mask in the bcl2fastq line:

run_folder="/net/shendure/vol9/seq/NOVASEQ/221221_12_02_22_A-D_birth/net/grc/vol6/data/GRC54NS/raw/221219_A01156_0622_A_HMYJKDSX5"
sample_sheet="/net/shendure/vol2/projects/cxqiu/JAX_rna/run_28_birth_20221208/2022-12-02-A-D-birth-novaseq-samplesheet.csv"
output_folder="/net/shendure/vol2/projects/cxqiu/JAX_rna/run_28_birth_20221208/nobackup/fastq"


module load modules modules-init modules-gs
module load gmp/6.1.2
module load mpfr/4.0.1
module load mpc/1.1.0
module load gcc/8.2.0
module load bcl2fastq/2.20

echo "---------------start demultiplex-----------------------"
echo $(date)
echo "run folder is $run_folder"
echo "sample sheet is $sample_sheet"
echo "output_folder is $output_folder"

#create the output folder:
echocr	
echo start making the output_folder
mkdir -p $output_folder/report


# do the demultiplex
#change bases mask as needed
bcl2fastq --runfolder-dir $run_folder -o $output_folder --sample-sheet $sample_sheet --reports-dir $output_folder/report --barcode-mismatches 1 --create-fastq-for-index-reads --no-lane-splitting --use-bases-mask Y*,I*,I*,Y* --minimum-trimmed-read-length 0 --mask-short-adapter-reads 0

echo "------------------demultiplex done -----------------"
